#include <inc/camera.hpp>

Camera::Camera(void) {

  map_width = 16 * 12;
  map_height = 16 * 6;

  display_width = 768 / 4; // 4 is the display scale.
  display_height = 448 / 4;

  pan_x = 32.0;
  pan_y = 32.0;

  target_x = 0.0;
  target_y = 0.0;

  pan_speed = 2.0;
}

float Camera::getX(void) {

  return pan_x;
}

float Camera::getY(void) {

  return pan_y;
}

void Camera::pan(void) {

  pan_x = target_x - (display_width / 2) + 8;
  pan_y = target_y - (display_height / 2) + 8;

  if (pan_x < 16) {

    pan_x = 16;
  }

  if (pan_y < 16) {

    pan_y = 16;
  }

  if (pan_x > (map_width * 16) - display_width - 16) {

    pan_x = (map_width * 16) - display_width - 16;
  }

  if (pan_y > (map_height * 16) - display_height - 16) {

    pan_y = (map_height * 16) - display_height - 16;
  }
}

void Camera::setTarget(const float x, const float y) {

  target_x = x;
  target_y = y;
}
